<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Log extends Model 
{

    protected $table = 'log';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function users()
    {
        return $this->belongsTo('App\Models\Users', 'user_id');
    }

    public function log_data()
    {
        return $this->hasMany('App\Models\Log_data', 'log_id');
    }

}